/* 
 
 * protocol ESPNow
 * A comanda servo pe GPIO 13
 * 
 * */
#include <ESP32Servo.h>   
Servo Servo1; 
int angle=80;

#include <esp_now.h>
#include <WiFi.h>
#include <Wire.h>
#include <Adafruit_SSD1306.h>
#include <Adafruit_GFX.h>
#define OLED_ADDR   0x3C
Adafruit_SSD1306 display(-1);

typedef struct RxStruct
    {
    int potVal;   
    }RxStruct;
    RxStruct receivedData;
void OnDataRecv(const uint8_t * mac, const uint8_t *incomingData, int len)
  {
  memcpy(&receivedData, incomingData, sizeof(receivedData));
  }

void setup()
{
  Serial.begin(9600);
  Servo1.attach(13);
  
  display.begin(SSD1306_SWITCHCAPVCC, OLED_ADDR);

  display.clearDisplay();
  display.setTextSize(2);
  display.setTextColor(WHITE);
  display.setCursor(0,0);
  display.print("P2P Rx A=Servo EspNow");
  display.display();
  delay(2000); 
   WiFi.mode(WIFI_STA);
  if (esp_now_init() != ESP_OK)
  {
    Serial.println("Error initializing ESP-NOW");
    return;
  }
  esp_now_register_recv_cb(OnDataRecv);
  }

    void loop()
      {
  display.setTextColor(WHITE); 
  display.clearDisplay();
  display.setTextSize(2); 
  
  display.setCursor(0,0); 
  display.print("A=");
  display.print(receivedData.potVal);

  angle = map(receivedData.potVal, 0, 4100, 0, 180); 
      Servo1.write(angle); 
      //Serial.println(" angle=");
      display.print(" ");
      display.print(angle); 
  display.display();
}
